/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                        *** MSC/TC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : DEMOFM.C                                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates how to call the SBFM low level functions */
/*       to play a 'C major scale' using each of the 10 instruments         */
/*       defined.                                                           */
/*                                                                          */
/*       The program is responsible for the timing between notes.           */
/*                                                                          */
/*       The program checks the BLASTER environment for the Card settings.  */
/*       It also performs a test based on the BLASTER environment settings  */
/*       to ensure they tally with the hardware settings on the Card.       */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <sbc.h>
#include <stdio.h>
#include <sbcmusic.h>
#include <bios.h>


/* instrument table */
char	  inst[128][16] =
    {
	       /* instrument1 */
        {   0x021,0x011,0x04C,0x000,0x0F1,0x0F2,0x063,0x072,
            0x000,0x000,0x004,0x000,0x000,0x000,0x000,0x000 },

        {   0x0A5,0x0B1,0x0D2,0x080,0x081,0x0F1,0x003,0x005,
            0x000,0x000,0x002,0x000,0x000,0x000,0x000,0x000 },

        {   0x072,0x062,0x01C,0x005,0x051,0x052,0x003,0x013,
            0x000,0x000,0x00E,0x000,0x000,0x000,0x000,0x000 },

        {   0x011,0x001,0x08A,0x040,0x0F1,0x0F1,0x011,0x0B3,
            0x000,0x000,0x006,0x000,0x000,0x000,0x000,0x000 },

        {   0x021,0x011,0x011,0x000,0x0A3,0x0C4,0x043,0x022,
            0x002,0x000,0x00D,0x000,0x000,0x000,0x000,0x000 },

	       /* instrument6 */
        {   0x031,0x0A1,0x01C,0x080,0x041,0x092,0x00B,0x03B,
            0x000,0x000,0x00E,0x000,0x000,0x000,0x000,0x000 },

        {   0x071,0x062,0x0C5,0x005,0x06E,0x08B,0x017,0x00E,
            0x000,0x000,0x002,0x000,0x000,0x000,0x000,0x000 },

        {   0x041,0x091,0x083,0x000,0x065,0x032,0x005,0x074,
            0x000,0x000,0x00A,0x000,0x000,0x000,0x000,0x000 },

        {   0x032,0x016,0x087,0x080,0x0A1,0x07D,0x010,0x033,
            0x000,0x000,0x008,0x000,0x000,0x000,0x000,0x000 },

        {   0x001,0x013,0x08D,0x000,0x051,0x052,0x053,0x07C,
            0x001,0x000,0x00C,0x000,0x000,0x000,0x000,0x000 }
    } ;

	  /* Only first 10 instruments are defined here */


main ()
{
    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 2)
        {
            sbfd_init () ;

            sbfd_instrument ( (char far *) inst ) ;

            PlayScale () ;

            sbfd_reset () ;
        }
        else
            printf("FM music not available or wrong I/O settings.\n") ;
    }
    else
        printf("BLASTER environment not set or incomplete or invalid.\n");

}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   PlayScale (void)                                                       */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Play a 'major scale' for each of the 10 instruments defined.       */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None                                                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None                                                               */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma loop_opt(off)
PlayScale (void)
{
    unsigned int   i, j ;
    int        inst ;
    int        note ;


    /* Look up table for the MIDI value of a 'scale' that starts from 'middle C' */
    static char     note_num[] = { 60, 62, 64, 65, 67, 69, 71, 72 } ;

    for ( inst= 0; inst < 10; inst++ )
    {
        sbfd_program_change ( 0, (char)inst ) ;

        for ( note=0; note < 8; note++ )
        {
            sbfd_note_on ( 0, note_num[note], 0x40 ) ;

            /* delay between notes */
            for (i=0; i<100; i++)
                for (j=0; j < 1000; j++) ;

            sbfd_note_off ( 0, note_num[note], 0x40 ) ;
        }
    }
}
#pragma loop_opt()
